//----------------------------------------------------------------------------------------
// Name:        image_dialog.cpp
// Purpose:     Insert an image dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: image_dialog.cpp,v 1.1 2002/01/04 03:34:27 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "image_dialog.cpp"
    #pragma interface "image_dialog.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"          // XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "image_dialog.h"
#include "editor_dialog.h"
#include "utils_controls.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

image_dialog* the_image_dialog = NULL;

// ---------------------------------------------------------------------------------------
// Event table: connect the events to the handler functions to process them
// ---------------------------------------------------------------------------------------

BEGIN_EVENT_TABLE( image_dialog, wxDialog )
    EVT_BUTTON( XMLID( "image_dialog_src_button" ), image_dialog::on_src_button )
    EVT_BUTTON( XMLID( "image_dialog_color_button" ), image_dialog::on_color_button )
    EVT_BUTTON( wxID_CONTEXT_HELP, image_dialog::on_help_button )
    EVT_BUTTON( wxID_OK, image_dialog::OnOK )
END_EVENT_TABLE()

//----------------------------------------------------------------------------------------
// Non-event handler functions
//----------------------------------------------------------------------------------------

void init_a_image_dialog( wxWindow* parent )
{
    the_image_dialog = new image_dialog;
    wxTheXmlResource->LoadDialog( the_image_dialog, parent, "image_dialog" );    
    
    the_image_dialog->ShowModal();
}

//----------------------------------------------------------------------------------------
// Event handlers
//----------------------------------------------------------------------------------------

void image_dialog::on_src_button( wxCommandEvent &event )
{
    // [utils_controls.cpp]    
    textctrl_filename_selection( XMLCTRL( *the_image_dialog, "image_dialog_src_textctrl", wxTextCtrl ),
                                 _T( "Choose image source file" ),
                                 "",
                                 "",
                                 FILE_DIALOG_WILDCARDS_IMAGES,
                                 false,
                                 ';' );                                
}


void image_dialog::on_color_button( wxCommandEvent &event )
{
    // [utils_controls.cpp]    
    textctrl_hex_color_selection( XMLCTRL( *the_image_dialog, "image_dialog_color_textctrl", wxTextCtrl ) );
}


void image_dialog::on_help_button( wxCommandEvent &event )
{

}


// Override wxDialog's default behavior for clicking an OK button.
void image_dialog::OnOK( wxCommandEvent& event )
{
    wxString output_string;
    wxString buf;
    
    wxString href_string = XMLCTRL( *the_image_dialog, "image_dialog_href_textctrl", wxTextCtrl )->GetValue();
    if ( href_string != "" ) {
        output_string += "<a href=\"" + href_string + "\">";
    }    
    
    output_string += "<img";    

    wxString src_string = XMLCTRL( *the_image_dialog, "image_dialog_src_textctrl", wxTextCtrl )->GetValue();    
    output_string += " src=\"" + src_string + '\"';
    // TODO: relative, using the editor dialogs page
        
    wxString alt_string = XMLCTRL( *the_image_dialog, "image_dialog_alt_textctrl", wxTextCtrl )->GetValue();
    if ( alt_string != "" ) {
        output_string += " alt=\"" + alt_string + "\"";
    }    
    
    wxString color_string = XMLCTRL( *the_image_dialog, "image_dialog_color_textctrl", wxTextCtrl )->GetValue();
    if ( color_string != "" ) {
        output_string += " color=\"" + color_string + "\"";
    }         
     
    output_string += ">";
    
    if ( href_string != "" ) {
        output_string += "</a>";
    }
    
    the_editor_dialog->stc_or_textctrl_insert_text( output_string, "", TRUE );
    
    // Get rid of the modal dialog. Not transferring any info from this modal's control
    // to a parent dialog, so don't have to bother with wxWindow::Validate or 
    // wxWindow::TransferDataFromWindow.    
    EndModal( wxID_OK );
}