//----------------------------------------------------------------------------------------
// Name:        install_dialog.cpp
// Purpose:     Install handheld software dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: install_dialog.cpp,v 1.3 2001/11/26 20:09:01 nordstrom Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "install_dialog.cpp"
    #pragma interface "install_dialog.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/file.h"
// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"          //XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "install_dialog.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

install_dialog* the_install_dialog = NULL;

// ---------------------------------------------------------------------------------------
// Event table: connect the events to the handler functions to process them
// ---------------------------------------------------------------------------------------

BEGIN_EVENT_TABLE( install_dialog, wxDialog )
    EVT_BUTTON( XMLID( "install_dialog_sync_directory_button" ), install_dialog::on_directory_button )
END_EVENT_TABLE()

void init_a_install_dialog( wxWindow* parent )
{      
    the_install_dialog = new install_dialog; 
    wxTheXmlResource->LoadDialog( the_install_dialog, parent, "install_dialog" );
    
    XMLCTRL(*the_install_dialog, "install_dialog_device_choice", wxChoice)->SetSelection(0);
    XMLCTRL(*the_install_dialog, "install_dialog_language_choice", wxChoice)->SetSelection(1);        
    
    the_install_dialog->ShowModal();
}

//----------------------------------------------------------------------------------------
// Event handlers
//----------------------------------------------------------------------------------------

void install_dialog::on_directory_button( wxCommandEvent &event )
{
    // Pass some initial dir to wxDirDialog
    wxString dir_home;
    wxGetHomeDir( &dir_home );

    wxDirDialog dir_dlg( this, "Choose sync directory", dir_home );

    if ( dir_dlg.ShowModal() == wxID_OK )
    {
        XMLCTRL( *the_install_dialog, "install_dialog_sync_directory_textctrl", wxTextCtrl )->SetValue( dir_dlg.GetPath() );
    }

}

