//----------------------------------------------------------------------------------------
// Name:        plucker-desktop.cpp
// Purpose:     Core application
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: plucker-desktop.cpp,v 1.6 2001/12/24 04:27:31 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "plucker-desktop.cpp"
    #pragma interface "plucker-desktop.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/image.h"               // wxImage
#include "wx/splash.h"              // wxSplashScreen
#include "wx/fs_inet.h"             // wxInternetFSHandler [wxHtmlWindow->LoadPage(http:)]
// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"          // XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "plucker-desktop.h"
#include "configuration.h"
#include "main_dialog.h"

// ---------------------------------------------------------------------------------------
// Resources
// ---------------------------------------------------------------------------------------

// The application icon
#if defined(__WXGTK__) || defined(__WXMOTIF__)
    #include "resource/icons_application/application_icon.xpm"
#endif

// ---------------------------------------------------------------------------------------
// Event tables and other macros for the application
// ---------------------------------------------------------------------------------------

// Create a new application object: this macro will allow wxWindows to create
// the application object during program execution (it's better than using a
// static object for many reasons) and also declares the accessor function
// wxGetApp() which will return the reference of the right type (i.e. the_app and
// not wxApp)
IMPLEMENT_APP( the_app )

// ---------------------------------------------------------------------------------------
// Event handlers for the core application
// ---------------------------------------------------------------------------------------

// 'Main program' equivalent: the program execution "starts" here
bool the_app::OnInit()
{   
    // Add image handlers for PNG, GIF, and JPG files. Required, to be able to load
    // up and display these image types on the dialogs, htmlwindows, etc.
    wxImage::AddHandler( new wxPNGHandler );
    wxImage::AddHandler( new wxGIFHandler );
    wxImage::AddHandler( new wxJPEGHandler );
    
    // Add a handler for http:// file systems to be used just like local drive file systems 
    // For example, used in showcase_dialog.h to download a preview page from internet.
    // Can add a zip filesystem handler too later for resources and html help files if so
    // desired.
    wxFileSystem::AddHandler( new wxInternetFSHandler );

    // Call up our saved configuration file
    init_configuration();    
    
    // Get the path to the resource files 
    wxString resource_file;
    // Load up the XML handlers and then load the resources from the resource file. 
    wxTheXmlResource->InitAllHandlers();
    resource_file = get_plucker_directory( RESOURCES ) << "/resource.xrc";
    wxTheXmlResource->Load( resource_file );
    resource_file = get_plucker_directory( RESOURCES ) << "/editor.xrc";
    wxTheXmlResource->Load( resource_file );
    
    // Build and show the main dialog
    init_a_main_dialog();    
    wxLogDebug( "Created main dialog" );    
    
    // Since a wxDialog is the top window of the app (instead of the usual
    // wxFrame), need to specify the dialog as top window of the application.
    SetTopWindow( the_main_dialog );
    wxLogDebug( "Set main dialog as top window" );
      
    // Returning TRUE continues the application (FALSE would stop application)
    return TRUE;
}

// Things to do when program is ended
int the_app::OnExit(void)
{
    // Delete the configuration object when finished program, otherwise memory leak
    finish_configuration();
    
    // TODO: Docs don't say what the int to return is. Using 0 since other wx programs do.
    return 0;
}
