//----------------------------------------------------------------------------------------
// Name:        setup.h
// Purpose:     Compilation settings
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: setup.h,v 1.5 2002/01/02 01:20:39 robertoconnor Exp $
//----------------------------------------------------------------------------------------

#ifndef _SETUP_H_
#define _SETUP_H_

//----------------------------------------------------------------------------------------
// Feature segment defines
//----------------------------------------------------------------------------------------

// This toggles inclusion of the Styled Text Control (STC), which is located in a wxwindows
// distribution in the directory: /contrib/src/stc
// TODO: Test under WXGTK.
#if defined(__WXGTK__) || defined(__WXMSW__)
    #define USE_STYLED_TEXT_CONTROL         1
#else
    #define USE_STYLED_TEXT_CONTROL         0
#endif

// Whether to use busy cursors for time-intensive operations
#define USE_BUSY_CURSOR                     1   

//----------------------------------------------------------------------------------------
// wxWindows bug workaround defines
//----------------------------------------------------------------------------------------


//----------------------------------------------------------------------------------------
// Compiler-specific defines
//----------------------------------------------------------------------------------------

// A workaround for Cygwin timezone adding timezone hours when getting Now() or getting/
// parsing a wxDateTime.
#if defined(__GNUWIN32__)
    #define USE_CYGWIN_GMT_ADJUSTMENT       1
#else
    #define USE_CYGWIN_GMT_ADJUSTMENT       0
#endif

//----------------------------------------------------------------------------------------
// OS-specific defines: MSW
//----------------------------------------------------------------------------------------

// An icon for the main dialog and taskbar under MSW. Takes a much longer compilation since have to
// include /msw/private.h so this switch turns it off in debug-builds. Modify to 1 to have the icon appear in
// debug builds too.
#if defined(__WIN95__) && ! defined(__WXDEBUG__)
    #define USE_MSW_DIALOG_TASKBAR_ICON     1
#else
    #define USE_MSW_DIALOG_TASKBAR_ICON     0
#endif


//----------------------------------------------------------------------------------------
#endif      //_SETUP_H_