//----------------------------------------------------------------------------------------
// Name:        showcase_dialog.h
// Purpose:     Plucker channel showcase dialog (renders plucker_showcase.xml)
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/26
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: showcase_dialog.h,v 1.6 2002/01/02 01:20:39 robertoconnor Exp $
//----------------------------------------------------------------------------------------

#ifndef _SHOWCASE_DIALOG_H_
#define _SHOWCASE_DIALOG_H_

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------
#include "setup.h"              // Plucker-Desktop compilation settings:
                                // modify to turn on/off certain code sections 
// ---------------------------------------------------------------------------------------
#include "wx/dialog.h"
#include "wx/listctrl.h"
#include "wx/splitter.h"
#include "wx/html/htmlwin.h"

//----------------------------------------------------------------------------------------
// Define a new dialog type
//----------------------------------------------------------------------------------------

class showcase_dialog : public wxDialog
{
public: 
    void read_configuration();
    void write_configuration();
    
    void listctrl_init();
    void listctrl_stretch_columns_to_fit();
    void init_splitters();
    void load_details_htmlwindow_content( long item_id );
    void load_preview_htmlwindow_content( wxString url );
    
    void on_listctrl_item_selected( wxListEvent& event ); 
    void on_update_ui_preview_checkbox( wxUpdateUIEvent &event );
    void on_update_ui_details_checkbox( wxUpdateUIEvent &event );
    // TODO: wxWindows: doesn't work like this. Events not getting passed up to parent
    void on_main_splitterwindow_sash_pos_changed( wxCommandEvent& event );
    // Override base class functions
    void OnOK( wxCommandEvent& event );

    // Controls not in XML resources. The <unknown> class in XML resource is the
    // placeholder container that is used by the main_splitterwindow, and the others
    // being children of main_splitterwindow.
    wxListCtrl*         showcase_listctrl;
    wxSplitterWindow*   main_splitterwindow;
    wxSplitterWindow*   details_preview_splitterwindow;
    wxHtmlWindow*       details_htmlwindow;
    wxHtmlWindow*       preview_htmlwindow;
    
    wxHtmlWindow*       dummy_htmlwindow;   // A dummy htmlwindow to parse showcase file    
private:
    DECLARE_EVENT_TABLE()    
};


//----------------------------------------------------------------------------------------
// External functions and variables
//----------------------------------------------------------------------------------------

extern showcase_dialog*     the_showcase_dialog;
void init_a_showcase_dialog( wxWindow* parent );

// Used to load up the multichoice dialogs in main dialog->advanced tab->showcase_panel
// Recycled for column title names in translations. Keep same number/name as the enum of
// column names in showcasedialog.cpp
const wxString showcase_field_names[] = {
    _T( "Name" ), _T( "URL" ), _T( "Description" ), _T( "Language" ), _T( "Category" ), _T( "Update Frequency" ), 
    _T( "Image depth" ), _T( "Maximum Depth" ), _T( "Stay On Host" ), _T( "Stay Below")    
};

#endif  //_SHOWCASE_DIALOG_H_