//----------------------------------------------------------------------------------------
// Name:        span_dialog.cpp
// Purpose:     Insert a span dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: span_dialog.cpp,v 1.1 2002/01/04 03:34:27 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "span_dialog.cpp"
    #pragma interface "span_dialog.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"          // XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "span_dialog.h"
#include "editor_dialog.h"
#include "utils_controls.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

span_dialog* the_span_dialog = NULL;

// ---------------------------------------------------------------------------------------
// Event table: connect the events to the handler functions to process them
// ---------------------------------------------------------------------------------------

BEGIN_EVENT_TABLE( span_dialog, wxDialog )
    EVT_BUTTON( wxID_CONTEXT_HELP, span_dialog::on_help_button )
    EVT_BUTTON( wxID_OK, span_dialog::OnOK )
END_EVENT_TABLE()

//----------------------------------------------------------------------------------------
// Non-event handler functions
//----------------------------------------------------------------------------------------

void init_a_span_dialog( wxWindow* parent )
{
    the_span_dialog = new span_dialog;
    wxTheXmlResource->LoadDialog( the_span_dialog, parent, "span_dialog" );

    XMLCTRL( *the_span_dialog, "span_dialog_alignment_choice", wxChoice )->SetSelection( 0 );

    the_span_dialog->ShowModal();
}

//----------------------------------------------------------------------------------------
// Event handlers
//----------------------------------------------------------------------------------------

void span_dialog::on_help_button( wxCommandEvent &event )
{

}


// Override wxDialog's default behavior for clicking an OK button.
void span_dialog::OnOK( wxCommandEvent& event )
{
    wxString output_string;
    wxString buf;
    
    output_string = "<span";    

    int alignment_value = XMLCTRL( *the_span_dialog, "span_dialog_alignment_choice", wxChoice )->GetSelection();
    wxString alignment_string; 
    switch ( alignment_value ) {
        case 0:
            alignment_string = "1eft";            
            break;
        case 1:
            alignment_string = "right";            
            break;
        case 2:
            alignment_string = "center";            
            break;
    }     
    output_string += " alignment =\"" + alignment_string + '\"';
   
    output_string += ">";
    
    the_editor_dialog->stc_or_textctrl_insert_text( output_string, "</span>", FALSE );
    
    // Get rid of the modal dialog. Not transferring any info from this modal's control
    // to a parent dialog, so don't have to bother with wxWindow::Validate or 
    // wxWindow::TransferDataFromWindow.    
    EndModal( wxID_OK );
}

