//----------------------------------------------------------------------------------------
// Name:        symbol_dialog.cpp
// Purpose:     Insert a symbol dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: symbol_dialog.cpp,v 1.2 2002/01/04 08:49:28 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "symbol_dialog.cpp"
    #pragma interface "symbol_dialog.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/html/htmlwin.h"        // wxHtmlWindow
// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"          // XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "symbol_dialog.h"
#include "configuration.h"
#include "editor_dialog.h"
#include "utils_controls.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

symbol_dialog* the_symbol_dialog = NULL;

// Pixel sizes of symbol chart
#define SYMBOL_CHART_SQUARE_WIDTH           21
#define SYMBOL_CHART_SQUARE_HEIGHT          21
#define SYMBOL_CHART_BORDER_SIZE            1
#define SYMBOL_DIALOG_NUMBER_OF_COLUMNS     17

const wxString entities[] = {
    "&quot;",
    "&lt;",
    "&trade;",
    "&pound;",
    "&yen;",
    "&sect;",
    "&copy;",
    "&laquo;",
    "&copy;",
    "&macr;",
    "&sup1;",
    "&sup3;",
    "&micro;",
    "&middot;",
    "&plusmn;",
    "&frac14;",
    "&amp;",
    "&gt;",
    "&nbsp;",
    "&cent;",
    "&curren;",
    "&brvbar;",
    "&uml;",
    "&ordf;",
    "&raquo;",
    "&reg;",
    "&deg;",
    "&sup2;",
    "&acute;",
    "&para;",
    "&cedil;",
    "&ordm;",
    "&frac12;",
    "&iquest;",
    "&Aacute;",
    "&Atilde;",
    "&Aring;",
    "&Ccedil;",
    "&Eacute;",
    "&Euml;",
    "&Iacute;",
    "&Iuml;",
    "&Ntilde;",
    "&Oacute;",
    "&Otilde;",
    "&times;",
    "&Ugrave;",
    "&Ucirc;",
    "&Yacute;",
    "&frac34;",
    "&Agrave;",
    "&Acirc;",
    "&Auml;",
    "&AElig;",
    "&Egrave;",
    "&Ecirc;",
    "&Igrave;",
    "&Icirc;",
    "&ETH;",
    "&Ograve;",
    "&Ocirc;",
    "&Ouml;",
    "&Oslash;",
    "&Uacute;",
    "&Uuml;",
    "&THORN;",
    "&agrave;",
    "&acirc;",
    "&auml;",
    "&aelig;",
    "&egrave;",
    "&ecirc;",
    "&igrave;",
    "&icirc;",
    "&eth;",
    "&ograve;",
    "&ocirc;"    
};

// ---------------------------------------------------------------------------------------
// Event tables: connect the events to the handler functions to process them
// ---------------------------------------------------------------------------------------

BEGIN_EVENT_TABLE( symbol_dialog, wxDialog )
    EVT_BUTTON( wxID_CONTEXT_HELP, symbol_dialog::on_help_button )
    EVT_BUTTON( wxID_OK, symbol_dialog::OnOK )
END_EVENT_TABLE()

//----------------------------------------------------------------------------------------
// Non-event handler functions: Symbol dialog
//----------------------------------------------------------------------------------------

void init_a_symbol_dialog( wxWindow* parent )
{
    the_symbol_dialog = new symbol_dialog;
    wxTheXmlResource->LoadDialog( the_symbol_dialog, parent, "symbol_dialog" );    

    wxString entities_filename = get_plucker_directory( RESOURCES ) + "/html_entities/entities.htm";

    the_symbol_dialog->m_graphic_htmlwindow = new symbol_htmlwindow( the_symbol_dialog, -1 );  

    wxTheXmlResource->AttachUnknownControl( _T( "symbol_dialog_graphic_htmlwindow" ),
                                            the_symbol_dialog->m_graphic_htmlwindow );
               
    XMLCTRL( *the_symbol_dialog, "symbol_dialog_graphic_htmlwindow", wxHtmlWindow )
        ->LoadPage( entities_filename );

    the_symbol_dialog->ShowModal();
}

//----------------------------------------------------------------------------------------
// Event handlers: Symbol dialog
//----------------------------------------------------------------------------------------


void symbol_dialog::on_help_button( wxCommandEvent &event )
{

}


// Override wxDialog's default behavior for clicking an OK button.
void symbol_dialog::OnOK( wxCommandEvent& event )
{
    wxString output_string;
   
    wxString entity_string = XMLCTRL( *the_symbol_dialog, "symbol_dialog_edit_textctrl", wxTextCtrl )->GetValue();
    output_string += entity_string;
    
    the_editor_dialog->stc_or_textctrl_insert_text( output_string, "", TRUE );
    
    // Get rid of the modal dialog. Not transferring any info from this modal's control
    // to a parent dialog, so don't have to bother with wxWindow::Validate or 
    // wxWindow::TransferDataFromWindow.    
    EndModal( wxID_OK );
}

//----------------------------------------------------------------------------------------
// Non-event handlers: Symbol htmlwindow
//----------------------------------------------------------------------------------------

// Constructor
symbol_htmlwindow::symbol_htmlwindow( wxWindow *parent, wxWindowID id ) 
       : wxHtmlWindow( parent, id, wxDefaultPosition, wxDefaultSize, wxHW_SCROLLBAR_NEVER )
{
    // Set border to zero, so image flush to edge
    SetBorders( 0 );    
}
       
symbol_htmlwindow::~symbol_htmlwindow()
{
}    

//----------------------------------------------------------------------------------------
// Event handlers: Symbol htmlwindow
//----------------------------------------------------------------------------------------

// Overriding wxHtmlWindow for a "cell" being clicked. A "cell" in wxHtmlWindow is a region.
void symbol_htmlwindow::OnCellClicked( wxHtmlCell *cell, wxCoord x, wxCoord y, const wxMouseEvent& event )
{
    wxLogDebug( "Coord x=%ld", x );
    wxLogDebug( "Coord y =%ld", y );
    // Deduce the clicked grid_number (ie the grid number of the image, counting from the upper left as 0,
    // down to the last grid_number down in the lower right ).
    int clicked_column =  x / ( SYMBOL_CHART_SQUARE_HEIGHT );
    int clicked_row = y / ( SYMBOL_CHART_SQUARE_WIDTH );    
    
    int clicked_grid_number = ( SYMBOL_DIALOG_NUMBER_OF_COLUMNS * clicked_row ) + clicked_column;

    wxLogDebug( "clicked_row=%ld", clicked_row  );
    wxLogDebug( "clicked_column=%ld", clicked_column );
    wxLogDebug( "clicked_grid_number=%ld", clicked_grid_number );

    wxString entity_string;
    // Make sure not accessing an element index larger than the arraysize
    if (  0 <= clicked_grid_number < (int) WXSIZEOF( entities )  ) {
        entity_string = entities[ clicked_grid_number ];
    }

    wxLogDebug( "entity_string=" + entity_string );
    XMLCTRL( *the_symbol_dialog, "symbol_dialog_edit_textctrl", wxTextCtrl )->SetValue( entity_string );

}