//----------------------------------------------------------------------------------------
// Name:        symbol_dialog.h
// Purpose:     Inserts a symbol dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2002/01/03
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: symbol_dialog.h,v 1.2 2002/01/04 08:49:28 robertoconnor Exp $
//----------------------------------------------------------------------------------------

#ifndef _SYMBOL_DIALOG_H_
#define _SYMBOL_DIALOG_H_

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#include "wx/dialog.h"

//----------------------------------------------------------------------------------------
// Define a new clickable htmlwindow type
//----------------------------------------------------------------------------------------
class symbol_htmlwindow : public wxHtmlWindow
{
public:      
    // Constructor and destructor 
    symbol_htmlwindow( wxWindow *parent, wxWindowID id );            
    ~symbol_htmlwindow();

    // Override base class virtual of clicking on a wxHtml "cell" (region)
    void OnCellClicked( wxHtmlCell *cell, wxCoord x, wxCoord y, const wxMouseEvent& event );
private:
};

//----------------------------------------------------------------------------------------
// Define a new dialog type
//----------------------------------------------------------------------------------------

class symbol_dialog : public wxDialog
{
public:      
    void on_help_button( wxCommandEvent &event );  
    //Override base class functions
    void OnOK( wxCommandEvent& event );
    
    // a symbol_htmlwindow
    symbol_htmlwindow* m_graphic_htmlwindow;
private:
    DECLARE_EVENT_TABLE()
};

//----------------------------------------------------------------------------------------
// External functions and variables
//----------------------------------------------------------------------------------------

extern symbol_dialog*     the_symbol_dialog;
void init_a_symbol_dialog( wxWindow* parent );

#endif  //_SYMBOL_DIALOG_H_

