//----------------------------------------------------------------------------------------
// Name:        table_dialog.cpp
// Purpose:     Insert an table dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: table_dialog.cpp,v 1.1 2002/01/04 03:34:27 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "table_dialog.cpp"
    #pragma interface "table_dialog.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/spinctrl.h"            // wxSpinCtrl
// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"          // XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "table_dialog.h"
#include "editor_dialog.h"
#include "utils_controls.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

table_dialog* the_table_dialog = NULL;

// ---------------------------------------------------------------------------------------
// Event table: connect the events to the handler functions to process them
// ---------------------------------------------------------------------------------------

BEGIN_EVENT_TABLE( table_dialog, wxDialog )
    EVT_UPDATE_UI( XMLID( "table_dialog_border_checkbox" ), table_dialog::on_update_ui_border_checkbox )
    EVT_BUTTON( XMLID( "table_dialog_border_color_button" ), table_dialog::on_border_color_button )
    EVT_BUTTON( wxID_CONTEXT_HELP, table_dialog::on_help_button )
    EVT_BUTTON( wxID_OK, table_dialog::OnOK )
END_EVENT_TABLE()

//----------------------------------------------------------------------------------------
// Non-event handler functions
//----------------------------------------------------------------------------------------

void init_a_table_dialog( wxWindow* parent )
{
    the_table_dialog = new table_dialog;
    wxTheXmlResource->LoadDialog( the_table_dialog, parent, "table_dialog" );    
    
    the_table_dialog->ShowModal();
}

//----------------------------------------------------------------------------------------
// Event handlers
//----------------------------------------------------------------------------------------

void table_dialog::on_update_ui_border_checkbox( wxUpdateUIEvent &event )
{
    bool enabled;
        
    enabled = XMLCTRL( *the_table_dialog, "table_dialog_border_checkbox", wxCheckBox )
            ->GetValue();
    XMLCTRL( *the_table_dialog, "table_dialog_border_color_textctrl", wxTextCtrl )
            ->Enable( enabled );      
    XMLCTRL( *the_table_dialog, "table_dialog_border_color_button", wxButton )
            ->Enable( enabled );    
}

void table_dialog::on_border_color_button( wxCommandEvent &event )
{
    // [utils_controls.cpp]    
    textctrl_hex_color_selection( XMLCTRL( *the_table_dialog, "table_dialog_border_color_textctrl", wxTextCtrl ) );
}


void table_dialog::on_help_button( wxCommandEvent &event )
{

}


// Override wxDialog's default behavior for clicking an OK button.
void table_dialog::OnOK( wxCommandEvent& event )
{
    wxString output_string;
   
    output_string += "<table";    
   
    bool use_border = XMLCTRL( *the_table_dialog, "table_dialog_border_checkbox", wxCheckBox )->GetValue();
    if ( use_border ) {
        output_string += " border=\"1\"";
    } else {
        output_string += " border=\"0\"";
    }
    
    wxString border_color_string = XMLCTRL( *the_table_dialog, "table_dialog_border_color_textctrl", wxTextCtrl )->GetValue();
    if ( use_border && border_color_string != "" ) {
        output_string += " border color=\"" + border_color_string + "\"";
    }     
    
    output_string += ">\n";   

    int number_of_rows = XMLCTRL( *the_table_dialog, "table_dialog_rows_spinctrl", wxSpinCtrl )->GetValue();
    int number_of_columns = XMLCTRL( *the_table_dialog, "table_dialog_columns_spinctrl", wxSpinCtrl )->GetValue();
    
    // Note that the _T is requred, or else it won't work.
    for ( int i=0; i < number_of_rows; i++ ) {
        output_string += "<tr>\n";
        for ( int n=0; n < number_of_columns; n++ ) {
            output_string += "<td></td>\n";
        }
        output_string += "</tr>\n";
    }
    
    output_string += "</table>";
    
    the_editor_dialog->stc_or_textctrl_insert_text( output_string, "", TRUE );
    
    // Get rid of the modal dialog. Not transferring any info from this modal's control
    // to a parent dialog, so don't have to bother with wxWindow::Validate or 
    // wxWindow::TransferDataFromWindow.    
    EndModal( wxID_OK );
}