//----------------------------------------------------------------------------------------
// Name:        ol_dialog.cpp
// Purpose:     Insert an ordered list (ol) dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/01/02
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: ul_dialog.cpp,v 1.1 2002/01/04 03:34:27 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "ul_dialog.cpp"
    #pragma interface "ul_dialog.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/spinctrl.h"            // wxSpinCtrl
// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"          // XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "ul_dialog.h"
#include "editor_dialog.h"
#include "utils_controls.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

ul_dialog* the_ul_dialog = NULL;

// ---------------------------------------------------------------------------------------
// Event table: connect the events to the handler functions to process them
// ---------------------------------------------------------------------------------------

BEGIN_EVENT_TABLE( ul_dialog, wxDialog )
    EVT_BUTTON( wxID_CONTEXT_HELP, ul_dialog::on_help_button )
    EVT_BUTTON( wxID_OK, ul_dialog::OnOK )
END_EVENT_TABLE()

//----------------------------------------------------------------------------------------
// Non-event handler functions
//----------------------------------------------------------------------------------------

void init_a_ul_dialog( wxWindow* parent )
{
    the_ul_dialog = new ul_dialog;
    wxTheXmlResource->LoadDialog( the_ul_dialog, parent, "ul_dialog" );   
    
    the_ul_dialog->ShowModal();
}

//----------------------------------------------------------------------------------------
// Event handlers
//----------------------------------------------------------------------------------------

void ul_dialog::on_help_button( wxCommandEvent &event )
{

}


// Override wxDialog's default behavior for clicking an OK button.
void ul_dialog::OnOK( wxCommandEvent& event )
{
    wxString output_string;

    output_string = "<ul";    
        
    int bullet_value = XMLCTRL( *the_ul_dialog, "ul_dialog_bullet_choice", wxChoice )->GetSelection();
    wxString bullet_string; 
    // Case 0 is 'Default'
    switch ( bullet_value ) {
        case 1:
            bullet_string = "sqaure";            
            break;
        case 2:
            bullet_string = "circle";            
            break;
    } 
    if ( bullet_value != 0 ) {
        output_string += " type=\"" + bullet_string + "\"";
    }
    
    bool compact = XMLCTRL( *the_ul_dialog, "ul_dialog_compact_checkbox", wxCheckBox )->GetValue(); 
    if ( compact ) {
        output_string += " compact";
    }
    
    output_string += ">";
    
    the_editor_dialog->stc_or_textctrl_insert_text( output_string, "</ul>", TRUE );
    
    // Get rid of the modal dialog. Not transferring any info from this modal's control
    // to a parent dialog, so don't have to bother with wxWindow::Validate or 
    // wxWindow::TransferDataFromWindow.    
    EndModal( wxID_OK );
}

