//----------------------------------------------------------------------------------------
// Name:        utils_string.cpp
// Purpose:     Utils for String management and conversion
// Author:      Robert O'Connor
// Modified by:
// Created:     2002/01/01
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: utils_string.cpp,v 1.3 2002/01/04 03:34:27 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------
#ifdef __GNUG__
    #pragma implementation "utils_string.cpp"
    #pragma interface "utils_string.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "utils_string.h"

//----------------------------------------------------------------------------------------
// Non-event handler functions
//----------------------------------------------------------------------------------------

// Converts a wxString to a wxArrayInt, based on the delimiter. 
void string_to_arrayint( wxString input_string, wxChar delimiter, wxArrayInt *output_arrayint,
                             bool ignore_trailing_delimiter )
{
    // Strip off the trailing delimiter if so requested
    if ( ignore_trailing_delimiter ) {
        if ( input_string.Last() == delimiter ) {
            input_string.RemoveLast();
        }
    }
    
    // Get number of array items, by number of delimiters + 1
    int number_of_array_items = input_string.Freq( delimiter ) + 1;

    // Loop through the string parsing
    wxString item_string;
    long item_long = 0;    
    for ( int i = 0; i < number_of_array_items; i++ ) {
        item_string = input_string.BeforeFirst( delimiter );
        // Check to see if string is of a number. If so, convert to a number type and add to string.
        if ( item_string.IsNumber() ) {
            item_string.ToLong( &item_long, 10 );
            output_arrayint->Add( (int) item_long );
        } else {
           wxLogMessage( "Plucker Error: Non-numerical item in a int array key in configuration file." ); 
        }
        input_string = input_string.AfterFirst( delimiter );
    }
}


// Converts a wxString to a wxArrayString, based on the delimiter. 
void string_to_arraystring( wxString input_string, wxChar delimiter, wxArrayString *output_arraystring,
                             bool ignore_trailing_delimiter )
{
    // Strip off the trailing delimiter if so requested
    if ( ignore_trailing_delimiter ) {
        if ( input_string.Last() == delimiter ) {
            input_string.RemoveLast();
        }
    }
    
    // Get number of array items, by number of delimiters + 1
    int number_of_array_items = input_string.Freq( delimiter ) + 1;

    // Loop through the string parsing
    wxString item_string;
    for ( int i = 0; i < number_of_array_items; i++ ) {
        item_string = input_string.BeforeFirst( delimiter );
        output_arraystring->Add( item_string );
        input_string = input_string.AfterFirst( delimiter );
    }
}


// Takes a wxColor type and converts it to a string like '#ffffff', ( with a preceeding # )  
// suitable for putting into an html page
wxString color_to_hex_string( wxColor input_color )
{  
    // See wx/src/common/utilscmn.cpp for wxDecToHex utility
    wxString red_hex = wxDecToHex( (int) input_color.Red() );
    wxString green_hex = wxDecToHex( (int) input_color.Green() );
    wxString blue_hex = wxDecToHex( (int) input_color.Blue() );
    
    wxString output_color_string = '#' + red_hex + green_hex + blue_hex;
    return output_color_string;
}


// Takes a hex color string of the form  '#ffffff', ( with a preceeding # ) and 
// converts it to a wxColor string
wxColor hex_string_to_color( wxString input_string )
{  
    // Shave off the leading #.
    input_string = input_string.AfterFirst( '#' );    
 
    // Extract the substrings using wxString::Mid();    
    wxString red_hex_string = input_string.Mid( 0, 2 );
    wxString green_hex_string = input_string.Mid( 2, 2 );
    wxString blue_hex_string = input_string.Mid( 4, 2 );
  
    // See wx/src/common/utilscmn.cpp for wxHexToDec utility   
    int red_hex_int = wxHexToDec( red_hex_string );
    int green_hex_int = wxHexToDec( green_hex_string );
    int blue_hex_int = wxHexToDec( blue_hex_string );
    
    wxColor output_color( red_hex_int, green_hex_int,  blue_hex_int );

    return output_color;
}

// Checks to see whether the string is a valid hex color string of the form  '#ffffff', 
// ( with a preceeding # )
bool is_valid_hex_color_string ( wxString input_string )
{    
    bool is_valid = true;
    
    // Check to see that isn't empty
    if ( input_string == "" ) { 
        is_valid = false;
    } else {
        // Check to see that it starts with a #
        if ( ! input_string.GetChar( 0 ) == '#' ) { 
            is_valid = false;
        } else {
            // Shave off the leading #
            input_string = input_string.AfterFirst( '#' );    
            // Make sure it isn't now empty ( since could have a '#' alone.
            if ( input_string == "" ) {
                is_valid = false;
            } else {
                // Check to see that the remaining string is 6 characters long.
                if ( ! ( input_string.Length() == 6 ) ) { 
                    is_valid = false;
                } else {
                    // Make sure all characters are allowed hex characters. 
                    wxString allowed_hex_chars = "0123456789ABCDEF"; 
                    wxString test_char;   
                    for ( size_t i=0; i < input_string.Length(); i++ ) {
                        test_char = input_string.GetChar( i );
                        if ( ! allowed_hex_chars.Contains( test_char ) ) {
                            is_valid = false;
                        }
                    }
                }                
            }
        }
    }
    return is_valid;        
}
