/*
 * bhistory.c:
 *
 * Copyright (c) 2002 James McKenzie <james@fishsoup.dhs.org>,
 * All rights reserved.
 *
 */

static char rcsid[] = "$Id:$";

/*
 * $Log:$
 */

#define HISTORY_SIZE 32

#include "const.h"
#include "resourceids.h"
#include "util.h"
#include "bhistory.h"
#include "browser.h"
#include "document.h"
#include "documentdata.h"
#include "session.h"

Char szHistory[] = "Plucker history";
static Int16 Historyid = 0;

typedef struct
{
  LocalID dbID;
  Int16 cardNo;
  Char docName[dmDBNameLength + 1];
}
History;


/*Do this by tracking documents and letting the document's history */
/*handle the rest*/
void
BrowserAddHistory (void)
{
  DmOpenRef oref;
  LocalID lid;
  History *hp, h;
  MemHandle mh;
  Preferences *prefs = Prefs ();
  UInt16 at = 0;


  lid = DmFindDatabase (0, szHistory);

  if (!lid)
    {
      DmCreateDatabase (0, szHistory, ViewerAppID, 'Hist', 0);
      lid = DmFindDatabase (0, szHistory);
    }

  if (!lid)
    return;

  oref = DmOpenDatabase (0, lid, dmModeReadWrite);
  if (!oref)
    return;

  mh = DmQueryRecord (oref, Historyid);

  if (mh)
    {
      hp = MemHandleLock (mh);
      if ((hp->dbID == prefs->dbID) && (hp->cardNo == prefs->cardNo))
        {
          MemHandleUnlock (mh);
          DmCloseDatabase (oref);
          return;
        }
      MemHandleUnlock (mh);
    }

  while (Historyid--)
    {
      if (DmNumRecords (oref))
        DmRemoveRecord (oref, 0);
    }

  Historyid = 0;


  h.dbID = prefs->dbID;
  h.cardNo = prefs->cardNo;
  StrNCopy (h.docName, prefs->docName, dmDBNameLength);


  mh = DmNewRecord (oref, &at, sizeof (h));
  if (mh)
    {
      hp = MemHandleLock (mh);
      if (hp)
        {
          DmWrite (hp, 0, &h, sizeof (h));
          MemHandleUnlock (mh);
        }
      DmReleaseRecord (oref, at, 0);
    }
  while (HISTORY_SIZE < DmNumRecords (oref))
    DmRemoveRecord (oref, HISTORY_SIZE);

  DmCloseDatabase (oref);

}

void
BrowserDirection (Int16 d)
{
  Char *url = NULL;

  Int16 ohid=Historyid;
  Int16 recordId;
  LocalID lid;
  DmOpenRef oref;
  MemHandle mh;
  History *hp;
  LocalID dbID;
  Int16 cardNo;
  char name[dmDBNameLength + 1];

  dbID = Prefs ()->dbID;
  cardNo = Prefs ()->cardNo;
  StrCopy (name, Prefs ()->docName);

  Historyid -= d;
  if (Historyid < 0)
    Historyid = 0;

  lid = DmFindDatabase (0, szHistory);
  if (!lid)
    return;
  oref = DmOpenDatabase (0, lid, dmModeReadWrite);
  if (!oref)
    return;

  if (DmNumRecords (oref) <= Historyid)
    Historyid = DmNumRecords (oref) - 1;

  mh = DmQueryRecord (oref, Historyid);
  if (mh)
    {
      hp = MemHandleLock (mh);
      if (hp)
        {
          Prefs ()->dbID = hp->dbID;
          Prefs ()->cardNo = hp->cardNo;
          StrNCopy (Prefs ()->docName, hp->docName, dmDBNameLength);
        }
      MemHandleUnlock (mh);
    }
  DmCloseDatabase (oref);

  SaveSessionData ();
  CloseDocument ();


  if (OpenDocument (Prefs ()->dbID, Prefs ()->cardNo) != errNone)
    {
      OpenDocument (dbID, cardNo);
      Prefs ()->dbID = dbID;
      Prefs ()->cardNo = cardNo;
      StrCopy (Prefs ()->docName, name);

	Historyid=ohid;
    }

  InitSessionData ();
  FrmGotoForm (Prefs ()->toolbar);

  return;
}
