/*
 * $Id: categorydata.h,v 1.8 2001/07/29 14:41:22 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __PLUCKER_CATEGORYDATA_H
#define __PLUCKER_CATEGORYDATA_H

#include "viewer.h"

#define BaseLength 32

typedef struct {
    Char    name[dmDBNameLength];
    Char    base[BaseLength];
    UInt16  cardNo;
    UInt32  size;
    UInt32  created;
    UInt16  attributes;
    UInt16  categories;
} DocumentInfo;


Boolean CategoryExists( UInt8 index ) PLKRDB_SECTION;
Boolean GetCategoryName( UInt8 index, Char* name ) PLKRDB_SECTION;
Err OpenDocList( void ) PLKRDB_SECTION;
Err RemoveDocInfoRecord( UInt16 index ) PLKRDB_SECTION;
Err ReturnDocInfoHandle( const UInt16 index, MemHandle* hand ) PLKRDB_SECTION;
Err UpdateDocumentName( UInt16 index, const char*name ) PLKRDB_SECTION;
UInt8 SetCategoryName( UInt8 index, Char* name ) PLKRDB_SECTION;
UInt16 GetNumOfDocuments( void ) PLKRDB_SECTION;
UInt8 GetCategoryIndex( Char* category ) PLKRDB_SECTION;
void CloseDocList( void ) PLKRDB_SECTION;
void MergeCategories( UInt8 dst, UInt8 src ) PLKRDB_SECTION;
void RemoveCategoryName( UInt8 index ) PLKRDB_SECTION;
UInt8 AddCategoryToFreePosition( Char* name ) PLKRDB_SECTION;

#endif
