/*
 * $Id: debug.c,v 1.18 2001/11/26 20:09:01 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifdef DEBUG

#include "debug.h"
#include <unix_stdarg.h>


/***********************************************************************
 *
 *      Internal Constants
 *
 ***********************************************************************/
#define MAX_MSG_LEN     256
#define COUNT_TICKS     true



/* Create formatted debug message */
Char *_
    (
    Char* fmt,  /* format, see printf( 3 ) for details */
    ...         /* arguments */
    )
{
    static Char   msg[ MAX_MSG_LEN ];
    va_list       args;

    va_start( args, fmt );
    StrVPrintF( msg, fmt, args );
    va_end( args );

    return msg;
}



void _DebugMsg
    (
    Char* fname,    /* file name */
    Int16 line,     /* line number */
    Char* title,    /* title */
    Char* function, /* function name */
    Char* msg       /* text message */
    )
{
    static Boolean  printFileLineTitle      = true;
    static Char     logBuf[ MAX_MSG_LEN ];
    static Char     logMsg[ MAX_MSG_LEN ];

    HostFILE*       fh;
    Char*           s;
    Char*           logfile;

    logfile = HostGetEnv( "PLUCKERLOG" );
    if ( logfile != NULL ) {
        fh = HostFOpen(logfile, "a" );
    }
    else {
        fh = HostLogFile();
    }

    if (fh == NULL) {
        return;
    }

    if ( printFileLineTitle ) {
        StrPrintF( logBuf, "[ %s ] %s:%d:", title, fname, line );
        StrPrintF( logMsg, "%-25s", logBuf );
        HostFPutS( logMsg, fh );
        HostFFlush( fh );
        printFileLineTitle = false;
    }

    if ( COUNT_TICKS ) {
        StrPrintF( logMsg, " [ ticks: %ld ] ", TimGetTicks() );
        HostFPutS( logMsg, fh );
        HostFFlush( fh );
    }
    StrPrintF( logMsg, "%s: %s", function, msg );
    HostFPutS( logMsg, fh );
    HostFFlush( fh );
    HostFClose( fh );

    s = msg;
    if ( *s != '\0' ) {
        while ( *s != '\0' ) {
            ++s;
        }
        printFileLineTitle = ( s[ -1 ] == '\n' );
    }
}

#endif
