/*
 * $Id: document.h,v 1.29 2001/12/14 19:02:31 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __PLUCKER_DOCUMENT_H
#define __PLUCKER_DOCUMENT_H

#include "viewer.h"
#include "prefsdata.h"


typedef enum {
    DATATYPE_PHTML              = 0,
    DATATYPE_PHTML_COMPRESSED   = 1,
    DATATYPE_TBMP               = 2,
    DATATYPE_TBMP_COMPRESSED    = 3,
    DATATYPE_MAILTO             = 4,
    DATATYPE_LINK_INDEX         = 5,
    DATATYPE_LINKS              = 6,
    DATATYPE_LINKS_COMPRESSED   = 7,
    DATATYPE_BOOKMARKS          = 8,
    DATATYPE_CATEGORY           = 9,
    DATATYPE_BASE		= 127
} PluckerDataType;


/* records in a Plucker document always starts with a header */
typedef struct {
    UInt16          uid;
    UInt16          paragraphs;
    UInt16          size;
    PluckerDataType type;
} Header;


typedef struct {
    UInt16          uid;
    Int16           verticalOffset;
    Int16           firstVisibleParagraph;
    Int16           firstParagraphY;
    Int16           lastVisibleParagraph;
    Int16           lastParagraphY;
    Int16           height;
    UInt16          depth;
    FontModeType    font;
} MetaRecord;


Boolean ViewRecord( const Int16 recordId, const Boolean newPage,
            Int16 pOffset ) PLKRDB_SECTION;
Int16 GetSearchAdjustment( void ) PLKRDB_SECTION;
MemHandle GetCurrentRecord( void ) PLKRDB_SECTION;
MemHandle GetRecordHandle( const Int16 recordId ) PLKRDB_SECTION;
MemHandle GetMetaRecord( void );
MemHandle GetMetaHandle( const Int16 recordId, Boolean update ) PLKRDB_SECTION;
RectangleType* ViewportBounds( void ) PLKRDB_SECTION;
void DoPageMove( const Int16 pixels ) PLKRDB_SECTION;
void ResetHeight( void ) PLKRDB_SECTION;
void ResetRecordReferences( void ) PLKRDB_SECTION;
void SetIdle( void ) PLKRDB_SECTION;
void SetWorking( void ) PLKRDB_SECTION;

#endif
