/*
 * $Id: documentdata.h,v 1.23 2001/07/18 20:01:36 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __PLUCKER_DOCUMENTDATA_H
#define __PLUCKER_DOCUMENTDATA_H

#include "viewer.h"


/* Reserved record "names" */
#define MAX_RESERVED        4

#define HOME_PAGE           0
#define EXTERNAL_BOOKMARKS  1
#define PLUCKER_LINKS       2
#define CATEGORY            3

/* Internal record "names" */
#define MAX_INTERNAL        5

#define _HOME_PAGE          0
#define _INTERNAL_BOOKMARKS 1
#define _SHOW_IMAGES        2
#define _SESSION_DATA       3
#define _LINK_TABLE         4


typedef enum {
    DOCTYPE_UNKNOWN = 0,
    DOCTYPE_DOC     = 1,
    DOCTYPE_ZLIB    = 2
} DocType;


typedef struct {
    UInt16 uid;
} UID;


typedef struct {
    UInt16 uid;
    UInt16 version;
    UInt16 records;
    UInt16 reserved[ 0 ];
} IndexRecord;


typedef struct {
    UInt16 uid;
    UInt16 records;
    UInt16 internal[ 0 ];
} MetaIndexRecord;


Boolean GetBitStatus( const UInt16 record, Int16 reference ) PLKRDB_SECTION;
Err AddBookmarkRecord( MemHandle* hand ) PLKRDB_SECTION;
Err OpenDocument( const LocalID dbID, UInt16 cardNo ) PLKRDB_SECTION;
Err RemoveBookmarkRecord( void ) PLKRDB_SECTION;
Err RenameDocument( Char* newName, Char* oldName,
        UInt16 oldCardNo ) PLKRDB_SECTION;
Err ReturnLastHandle(MemHandle* hand) PLKRDB_SECTION;
Err ReturnRecordHandle( const UInt16 id, MemHandle* hand ) PLKRDB_SECTION;
Err ReturnMetaHandle( UInt16 id, const UInt16 num, Boolean update,
        MemHandle* hand ) PLKRDB_SECTION;
Err ReturnNextRecordHandle( UInt16* index, MemHandle* hand,
        UInt16* uniqID ) PLKRDB_SECTION;
UInt16 GetDefaultCategories( LocalID dbID, UInt16 cardNo ) PLKRDB_SECTION;
UInt16 GetInternalID( UInt16 name ) PLKRDB_SECTION;
UInt16 GetNumOfRecords( void ) PLKRDB_SECTION;
UInt16 GetReservedID( UInt16 name ) PLKRDB_SECTION;
UInt16 ResizeRecord( const UInt16 id, const UInt16 size,
        MemHandle* hand ) PLKRDB_SECTION;
void CloseDocument( void ) PLKRDB_SECTION;
void DeleteMetaDocument( Char* name ) PLKRDB_SECTION;
void SetBitStatus( const UInt16 record, Int16 reference,
        Boolean setStatus ) PLKRDB_SECTION;


#define HOME_PAGE_ID            GetReservedID( HOME_PAGE )
#define EXTERNAL_BOOKMARKS_ID   GetReservedID( EXTERNAL_BOOKMARKS )
#define PLUCKER_LINKS_ID        GetReservedID( PLUCKER_LINKS )
#define CATEGORY_ID             GetReservedID( CATEGORY )

#define INTERNAL_BOOKMARKS_ID   GetInternalID( _INTERNAL_BOOKMARKS )
#define SHOW_IMAGES_ID          GetInternalID( _SHOW_IMAGES )
#define SESSION_DATA_ID         GetInternalID( _SESSION_DATA )
#define LINK_TABLE_ID           GetInternalID( _LINK_TABLE )

#endif
