/*
 * $Id: prefsdata.h,v 1.36 2001/10/27 18:56:41 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __PLUCKER_PREFERENCES_H
#define __PLUCKER_PREFERENCES_H

#include "viewer.h"
#include "resourceids.h"


#define ViewerVersion 1


/* NOTE: Don't change the order of the options */

#define proxyNameLength 200


#define NUM_OF_HW_BUTTONS   4
typedef enum {
    DATEBOOK_BUTTON,
    ADDRESS_BUTTON,
    TODO_BUTTON,
    MEMO_BUTTON
} HWButtons;


#define NUM_OF_GESTURES 5
typedef enum {
    GESTURES_UP,
    GESTURES_RIGHT,
    GESTURES_DOWN,
    GESTURES_LEFT,
    GESTURES_TAP
} Gestures;


typedef enum {
    MODE1 = 0,
    MODE2 = 1,
    MODE3 = 2
} ModeType;


typedef enum {
    SELECT_NONE = 0,
    SELECT_FULL_PAGE_UP,
    SELECT_HALF_PAGE_UP,
    SELECT_HALF_PAGE_DOWN,
    SELECT_FULL_PAGE_DOWN,
    SELECT_GO_BACK,
    SELECT_GO_FORWARD,
    SELECT_GO_HOME,
    SELECT_GO_TO_TOP,
    SELECT_GO_TO_BOTTOM,
    SELECT_FIND,
    SELECT_FIND_AGAIN,
    SELECT_ADD_BOOKMARK,
    SELECT_VIEW_BOOKMARKS,
    SELECT_OPEN_LIBRARY,
    SELECT_DETAILS,
    SELECT_PREFS,
    SELECT_BUTTON_ACTION,
    SELECT_TAP_ACTION,
    SELECT_GESTURE_ACTION,
    SELECT_TOGGLE_AUTOSCROLL,
    SELECT_INCREASE_AUTOSCROLL,
    SELECT_DECREASE_AUTOSCROLL
} SelectType;


typedef enum {
    SCROLLBAR_RIGHT = 0,
    SCROLLBAR_LEFT,
    SCROLLBAR_NONE
} ScrollbarType;


typedef enum {
    FILTER_OR = 0,
    FILTER_AND
} FilterType;


typedef enum {
    FONT_DEFAULT = 0,
    FONT_BOLD,
    FONT_LARGE,
    FONT_LARGEBOLD,
    FONT_NARROW
} FontModeType;


typedef enum {
    SORT_NAME = 0,
    SORT_DATE,
    SORT_SIZE
} SortType;


typedef enum {
    SORTORDER_ASC = 0,
    SORTORDER_DESC
} SortOrderType;


typedef enum {
    AUTOSCROLL_PIXELS = 0,
    AUTOSCROLL_PAGES
} AutoscrollModeType;

typedef enum {
    AUTOSCROLL_UP = 0,
    AUTOSCROLL_DOWN
} AutoscrollDirType;


#define NUM_OF_CONTROL_MODES 2
#define NUM_OF_CONTROL_LISTS 4

/*
   Viewer preferences

   New items must be added to the end of the list
 */
typedef struct {
    LocalID             dbID;
    Boolean             strikethrough;
    Boolean             showDate;
    Boolean             linkClick;
    Boolean             multipleSelect;
    ScrollbarType       scrollbar;
    ModeType            controlMode;
    SelectType          select[ NUM_OF_CONTROL_MODES ][ NUM_OF_CONTROL_LISTS ];
    UInt16              toolbar;
    UInt16              screenDepth;
    Boolean             searchInAllPages;
    Boolean             caseSensitive;
    UInt16              searchEntries;
    Boolean             showSize;
    UInt16              categories;
    UInt16              cardNo;
    Char                docName[ dmDBNameLength ];
    UInt16              toolbarButton;
    FilterType          filterMode;
    UInt16              lastForm;
    Boolean             underlineMode;
    FontModeType        fontMode;
    Boolean             hardKeys;
    SelectType          hwMode[ NUM_OF_HW_BUTTONS ];
    SortType            sortType;
    SortOrderType       sortOrder;
    Boolean             gestures;
    SelectType          gestMode[ NUM_OF_GESTURES ];
    Boolean             autoscrollEnabled;
    UInt16              autoscrollInterval;
    UInt16              autoscrollLastScrollTime;
    UInt16              autoscrollJump;
    AutoscrollModeType  autoscrollMode;
    AutoscrollDirType   autoscrollDir;
    Boolean             autoscrollStayOn;
    Int16		cacheid;
    Char 		proxyName[proxyNameLength];
} Preferences;


Char* GetSearchPatterns( void ) PLKRDB_SECTION;
Preferences* Prefs( void ) PLKRDB_SECTION;
void AddSearchString( Char* string ) PLKRDB_SECTION;
void GetSearchString( Char* string ) PLKRDB_SECTION;
void ReadPrefs( void ) PLKRDB_SECTION;
void ReleaseSearchPatterns( void ) PLKRDB_SECTION;
void WritePrefs( void ) PLKRDB_SECTION;

#endif
